<?php $__env->startSection('title', 'History'); ?>

<?php $__env->startSection('content'); ?>
<div class="mt-4">
    <div class="card">
        <div class="card-datatable table-responsive pt-0">
            <table class="datatables-basic table">
                <thead>
                    <tr>
                        <th></th>
                        <th></th>
                        <th>Receiver</th>
                        <th>Status</th>
                        <th>Created at</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        (function() {
            'use strict';
            var ilsya = new velixs()

            var dbs = ilsya.datatables({
                url: "<?php echo e(route('history')); ?>",
                url_delete: "<?php echo e(route('history.delete')); ?>",
                header: `History Message`,
                columns: [{
                        data: 'responsive_id'
                    },
                    {
                        data: 'responsive_id'
                    },
                    {
                        data: 'receiver'
                    },
                    {
                        data: 'status'
                    },
                    {
                        data: 'created_at'
                    },
                    {
                        data: 'action'
                    }
                ],
                btn: [
                    {
                        text: '<i class="ti ti-trash me-sm-1"></i> <span class="d-none d-sm-inline-block">Delete</span>',
                        className: 'is-button-delete btn me-2 btn-label-danger'
                    }
                ],
            })
        })()
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('cssvendor'); ?>
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
    <link rel="stylesheet" href="<?php echo asset('assets'); ?>/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('jsvendor'); ?>
    <script src="<?php echo asset('assets'); ?>/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dash.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Koding\www\wa-lazy\core\resources\views/history/index.blade.php ENDPATH**/ ?>